#include <stdint.h>

#define LIMIT 5u

void example ( void )
{
  uint16_t x, y, z;

/* ----------------- Example code from MISRA C:2012 begin ----------------- */

  /* Compliant */
  for ( x = 0; x < LIMIT; ++x )
  {
    if ( ExitNow ( x ) )
    {
      break;
    }

    for ( y = 0; y < x; ++y )
    {
      if ( ExitNow ( LIMIT - y ) )
      {
        break;
      }
    }
  }

  /* Non-compliant */
  for ( x = 0; x < LIMIT; ++x )
  {
    if ( BreakNow ( x ) )
    {
      break;
    }
    else if ( GotoNow ( x ) )
    {
      goto EXIT;
    }
    else
    {
      KeepGoing ( x );
    }
  }

EXIT:
  ;

  /* Non-compliant */
  while ( x != 0u )
  {
    x = calc_new_x ( );

    if ( x == 1u )
    {
      break;
    }

    /* Compliant */
    while ( y != 0u )
    {
      y = calc_new_y ( );

      if ( y == 1u )
      {
        goto L1;
      }
    }
  }

L1:
  z = x + y;

/* ------------------ Example code from MISRA C:2012 end ------------------ */
}
